/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.lines;

import com.intellij.rt.coverage.instrumentation.data.InstrumentationData;
import com.intellij.rt.coverage.instrumentation.data.Key;
import com.intellij.rt.coverage.instrumentation.filters.lines.CoverageFilter;
import com.intellij.rt.coverage.util.ClassNameUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.coverage.org.objectweb.asm.AnnotationVisitor;

public class AnnotationIgnoredMethodFilter
extends CoverageFilter {
    private boolean myShouldIgnore;

    /*
     * WARNING - void declaration
     */
    public boolean isApplicable(InstrumentationData context) {
        void var1_1;
        void var2_2;
        List<Pattern> includeAnnotations = context.getProjectContext().getOptions().includeAnnotations;
        List<Pattern> excludeAnnotations = context.getProjectContext().getOptions().excludeAnnotations;
        return includeAnnotations != null && !var2_2.isEmpty() || excludeAnnotations != null && !var1_1.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        void var2_2;
        void var1_1;
        void var3_3;
        String annotationName = ClassNameUtil.convertVMNameToFQN(descriptor);
        List<String> methodAnnotations = this.myContext.get(Key.METHOD_ANNOTATIONS);
        if (methodAnnotations == null) {
            methodAnnotations = new ArrayList<String>();
            this.myContext.put(Key.METHOD_ANNOTATIONS, methodAnnotations);
        }
        methodAnnotations.add((String)var3_3);
        return super.visitAnnotation((String)var1_1, (boolean)var2_2);
    }

    public void visitCode() {
        if (!this.myContext.getProjectContext().getFilteredStorage().checkMethodIncluded(this.myContext)) {
            this.myContext.setIgnoreSection(true);
            this.myShouldIgnore = true;
        }
        super.visitCode();
    }

    public void visitEnd() {
        super.visitEnd();
        if (this.myShouldIgnore) {
            this.myContext.setIgnoreSection(false);
        }
        this.myContext.put(Key.METHOD_ANNOTATIONS, null);
    }
}

