/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.plaf.UIDependent;
import org.jdesktop.swingx.util.Contract;

public class CompoundHighlighter
extends AbstractHighlighter
implements UIDependent {
    public static final Highlighter[] EMPTY_HIGHLIGHTERS = new Highlighter[0];
    protected List<Highlighter> highlighters = new ArrayList<Highlighter>();
    private ChangeListener highlighterChangeListener;

    public CompoundHighlighter(Highlighter ... inList) {
        this((HighlightPredicate)null, inList);
    }

    public CompoundHighlighter(HighlightPredicate predicate, Highlighter ... inList) {
        super(predicate);
        this.setHighlighters(inList);
    }

    public void setHighlighters(Highlighter ... inList) {
        Contract.asNotNull(inList, "Highlighter must not be null");
        if (this.highlighters.isEmpty() && inList.length == 0) {
            return;
        }
        this.removeAllHighlightersSilently();
        for (Highlighter highlighter : inList) {
            this.addHighlighterSilently(highlighter, false);
        }
        this.fireStateChanged();
    }

    private void removeAllHighlightersSilently() {
        for (Highlighter highlighter : this.highlighters) {
            highlighter.removeChangeListener(this.getHighlighterChangeListener());
        }
        this.highlighters.clear();
    }

    public void addHighlighter(Highlighter highlighter) {
        this.addHighlighter(highlighter, false);
    }

    public void addHighlighter(Highlighter highlighter, boolean prepend) {
        this.addHighlighterSilently(highlighter, prepend);
        this.fireStateChanged();
    }

    private void addHighlighterSilently(Highlighter highlighter, boolean prepend) {
        Contract.asNotNull(highlighter, "Highlighter must not be null");
        if (prepend) {
            this.highlighters.add(0, highlighter);
        } else {
            this.highlighters.add(this.highlighters.size(), highlighter);
        }
        this.updateUI(highlighter);
        highlighter.addChangeListener(this.getHighlighterChangeListener());
    }

    public void removeHighlighter(Highlighter hl) {
        boolean success = this.highlighters.remove(hl);
        if (success) {
            hl.removeChangeListener(this.getHighlighterChangeListener());
            this.fireStateChanged();
        }
    }

    public Highlighter[] getHighlighters() {
        if (this.highlighters.isEmpty()) {
            return EMPTY_HIGHLIGHTERS;
        }
        return this.highlighters.toArray(new Highlighter[this.highlighters.size()]);
    }

    @Override
    public void updateUI() {
        for (Highlighter highlighter : this.highlighters) {
            this.updateUI(highlighter);
        }
    }

    protected ChangeListener getHighlighterChangeListener() {
        if (this.highlighterChangeListener == null) {
            this.highlighterChangeListener = this.createHighlighterChangeListener();
        }
        return this.highlighterChangeListener;
    }

    protected ChangeListener createHighlighterChangeListener() {
        this.highlighterChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e2) {
                CompoundHighlighter.this.fireStateChanged();
            }
        };
        return this.highlighterChangeListener;
    }

    private void updateUI(Highlighter hl) {
        if (hl instanceof UIDependent) {
            ((UIDependent)((Object)hl)).updateUI();
        }
    }

    @Override
    protected Component doHighlight(Component stamp, ComponentAdapter adapter) {
        for (Highlighter highlighter : this.highlighters) {
            stamp = highlighter.highlight(stamp, adapter);
        }
        return stamp;
    }
}

