/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.calendar;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import org.jdesktop.swingx.calendar.CalendarUtils;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.event.DateSelectionEvent;
import org.jdesktop.swingx.event.DateSelectionListener;
import org.jdesktop.swingx.event.EventListenerMap;

public abstract class AbstractDateSelectionModel
implements DateSelectionModel {
    public static final SortedSet<Date> EMPTY_DATES = Collections.unmodifiableSortedSet(new TreeSet());
    protected EventListenerMap listenerMap = new EventListenerMap();
    protected boolean adjusting;
    protected Calendar calendar;
    protected Date upperBound;
    protected Date lowerBound;
    protected Locale locale;

    public AbstractDateSelectionModel() {
        this(null);
    }

    public AbstractDateSelectionModel(Locale locale) {
        this.setLocale(locale);
    }

    @Override
    public Calendar getCalendar() {
        return (Calendar)this.calendar.clone();
    }

    @Override
    public int getFirstDayOfWeek() {
        return this.calendar.getFirstDayOfWeek();
    }

    @Override
    public void setFirstDayOfWeek(int firstDayOfWeek) {
        if (firstDayOfWeek == this.getFirstDayOfWeek()) {
            return;
        }
        this.calendar.setFirstDayOfWeek(firstDayOfWeek);
        this.fireValueChanged(DateSelectionEvent.EventType.CALENDAR_CHANGED);
    }

    @Override
    public int getMinimalDaysInFirstWeek() {
        return this.calendar.getMinimalDaysInFirstWeek();
    }

    @Override
    public void setMinimalDaysInFirstWeek(int minimalDays) {
        if (minimalDays == this.getMinimalDaysInFirstWeek()) {
            return;
        }
        this.calendar.setMinimalDaysInFirstWeek(minimalDays);
        this.fireValueChanged(DateSelectionEvent.EventType.CALENDAR_CHANGED);
    }

    @Override
    public TimeZone getTimeZone() {
        return this.calendar.getTimeZone();
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        if (this.getTimeZone().equals(timeZone)) {
            return;
        }
        TimeZone oldTimeZone = this.getTimeZone();
        this.calendar.setTimeZone(timeZone);
        this.adjustDatesToTimeZone(oldTimeZone);
        this.fireValueChanged(DateSelectionEvent.EventType.CALENDAR_CHANGED);
    }

    protected void adjustDatesToTimeZone(TimeZone oldTimeZone) {
        this.clearSelection();
        this.setLowerBound(null);
        this.setUpperBound(null);
        this.setUnselectableDates(EMPTY_DATES);
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (locale.equals(this.getLocale())) {
            return;
        }
        this.locale = locale;
        this.calendar = this.calendar != null ? Calendar.getInstance(this.calendar.getTimeZone(), locale) : Calendar.getInstance(locale);
        this.fireValueChanged(DateSelectionEvent.EventType.CALENDAR_CHANGED);
    }

    protected Date startOfDay(Date date) {
        return CalendarUtils.startOfDay(this.calendar, date);
    }

    protected Date endOfDay(Date date) {
        return CalendarUtils.endOfDay(this.calendar, date);
    }

    protected boolean isSameDay(Date selected, Date compare) {
        return this.startOfDay(selected).equals(this.startOfDay(compare));
    }

    @Override
    public Date getUpperBound() {
        return this.upperBound;
    }

    @Override
    public void setUpperBound(Date upperBound) {
        if (upperBound != null) {
            upperBound = this.getNormalizedDate(upperBound);
        }
        if (CalendarUtils.areEqual(upperBound, this.getUpperBound())) {
            return;
        }
        this.upperBound = upperBound;
        if (this.upperBound != null && !this.isSelectionEmpty()) {
            long justAboveUpperBoundMs = this.upperBound.getTime() + 1L;
            this.removeSelectionInterval(new Date(justAboveUpperBoundMs), this.getLastSelectionDate());
        }
        this.fireValueChanged(DateSelectionEvent.EventType.UPPER_BOUND_CHANGED);
    }

    @Override
    public Date getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public void setLowerBound(Date lowerBound) {
        if (lowerBound != null) {
            lowerBound = this.getNormalizedDate(lowerBound);
        }
        if (CalendarUtils.areEqual(lowerBound, this.getLowerBound())) {
            return;
        }
        this.lowerBound = lowerBound;
        if (this.lowerBound != null && !this.isSelectionEmpty()) {
            long justBelowLowerBoundMs = this.lowerBound.getTime() - 1L;
            this.removeSelectionInterval(this.getFirstSelectionDate(), new Date(justBelowLowerBoundMs));
        }
        this.fireValueChanged(DateSelectionEvent.EventType.LOWER_BOUND_CHANGED);
    }

    @Override
    public boolean isAdjusting() {
        return this.adjusting;
    }

    @Override
    public void setAdjusting(boolean adjusting) {
        if (adjusting == this.isAdjusting()) {
            return;
        }
        this.adjusting = adjusting;
        this.fireValueChanged(adjusting ? DateSelectionEvent.EventType.ADJUSTING_STARTED : DateSelectionEvent.EventType.ADJUSTING_STOPPED);
    }

    @Override
    public void addDateSelectionListener(DateSelectionListener l) {
        this.listenerMap.add(DateSelectionListener.class, l);
    }

    @Override
    public void removeDateSelectionListener(DateSelectionListener l) {
        this.listenerMap.remove(DateSelectionListener.class, l);
    }

    public List<DateSelectionListener> getDateSelectionListeners() {
        return this.listenerMap.getListeners(DateSelectionListener.class);
    }

    protected void fireValueChanged(DateSelectionEvent.EventType eventType) {
        List<DateSelectionListener> listeners = this.getDateSelectionListeners();
        DateSelectionEvent e2 = null;
        for (DateSelectionListener listener : listeners) {
            if (e2 == null) {
                e2 = new DateSelectionEvent(this, eventType, this.isAdjusting());
            }
            listener.valueChanged(e2);
        }
    }
}

