/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.net.ConnectException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.Socket;
import java.net.UnknownServiceException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.Address;
import okhttp3.CertificatePinner;
import okhttp3.ConnectionSpec;
import okhttp3.Handshake;
import okhttp3.HttpUrl;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.internal._UtilJvmKt;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.connection.ConnectionUser;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.connection.RealRoutePlanner;
import okhttp3.internal.connection.RetryTlsHandshakeKt;
import okhttp3.internal.connection.ReusePlan;
import okhttp3.internal.connection.RoutePlanner;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http1.Http1ExchangeCodec;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.tls.CertificateChainCleaner;
import okhttp3.internal.tls.OkHostnameVerifier;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 U2\u00020\u00012\u00020\u0002:\u0001UB\u008f\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u0006\u0010\f\u001a\u00020\b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0016\u0012\u0006\u0010\u0017\u001a\u00020\b\u0012\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u0012\u0006\u0010\u001a\u001a\u00020\b\u0012\u0006\u0010\u001b\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u001cJ\b\u00108\u001a\u000209H\u0016J\u0006\u0010:\u001a\u000209J\b\u0010;\u001a\u000209H\u0002J\b\u0010<\u001a\u00020=H\u0016J\u0018\u0010>\u001a\u0002092\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0002J\b\u0010C\u001a\u00020=H\u0016J\r\u0010D\u001a\u00020=H\u0000\u00a2\u0006\u0002\bEJ2\u0010F\u001a\u00020\u00002\b\b\u0002\u0010\u0017\u001a\u00020\b2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\b\u0002\u0010\u001a\u001a\u00020\b2\b\b\u0002\u0010\u001b\u001a\u00020\u000eH\u0002J\n\u0010G\u001a\u0004\u0018\u00010\u0019H\u0002J\b\u0010H\u001a\u00020\u001fH\u0016J%\u0010I\u001a\u0004\u0018\u00010\u00002\f\u0010J\u001a\b\u0012\u0004\u0012\u00020B0\u00162\u0006\u0010?\u001a\u00020@H\u0000\u00a2\u0006\u0002\bKJ\b\u0010L\u001a\u000209H\u0016J#\u0010M\u001a\u00020\u00002\f\u0010J\u001a\b\u0012\u0004\u0012\u00020B0\u00162\u0006\u0010?\u001a\u00020@H\u0000\u00a2\u0006\u0002\bNJ\b\u0010O\u001a\u00020\u0001H\u0016J\u001a\u0010P\u001a\u0002092\u0006\u0010Q\u001a\u00020R2\b\u0010S\u001a\u0004\u0018\u00010TH\u0016R\u000e\u0010\u0017\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010\u001b\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010%R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0010\u0010/\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u00101\u001a\u0004\u0018\u00010*X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00106\u001a\u0004\u0018\u000107X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lokhttp3/internal/connection/ConnectPlan;", "Lokhttp3/internal/connection/RoutePlanner$Plan;", "Lokhttp3/internal/http/ExchangeCodec$Carrier;", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "connectionPool", "Lokhttp3/internal/connection/RealConnectionPool;", "readTimeoutMillis", "", "writeTimeoutMillis", "socketConnectTimeoutMillis", "socketReadTimeoutMillis", "pingIntervalMillis", "retryOnConnectionFailure", "", "user", "Lokhttp3/internal/connection/ConnectionUser;", "routePlanner", "Lokhttp3/internal/connection/RealRoutePlanner;", "route", "Lokhttp3/Route;", "routes", "", "attempt", "tunnelRequest", "Lokhttp3/Request;", "connectionSpecIndex", "isTlsFallback", "(Lokhttp3/internal/concurrent/TaskRunner;Lokhttp3/internal/connection/RealConnectionPool;IIIIIZLokhttp3/internal/connection/ConnectionUser;Lokhttp3/internal/connection/RealRoutePlanner;Lokhttp3/Route;Ljava/util/List;ILokhttp3/Request;IZ)V", "canceled", "connection", "Lokhttp3/internal/connection/RealConnection;", "getConnectionSpecIndex$okhttp", "()I", "handshake", "Lokhttp3/Handshake;", "isReady", "()Z", "isTlsFallback$okhttp", "protocol", "Lokhttp3/Protocol;", "rawSocket", "Ljava/net/Socket;", "getRoute", "()Lokhttp3/Route;", "getRoutes$okhttp", "()Ljava/util/List;", "sink", "Lokio/BufferedSink;", "socket", "getSocket$okhttp", "()Ljava/net/Socket;", "setSocket$okhttp", "(Ljava/net/Socket;)V", "source", "Lokio/BufferedSource;", "cancel", "", "closeQuietly", "connectSocket", "connectTcp", "Lokhttp3/internal/connection/RoutePlanner$ConnectResult;", "connectTls", "sslSocket", "Ljavax/net/ssl/SSLSocket;", "connectionSpec", "Lokhttp3/ConnectionSpec;", "connectTlsEtc", "connectTunnel", "connectTunnel$okhttp", "copy", "createTunnel", "handleSuccess", "nextConnectionSpec", "connectionSpecs", "nextConnectionSpec$okhttp", "noNewExchanges", "planWithCurrentOrInitialConnectionSpec", "planWithCurrentOrInitialConnectionSpec$okhttp", "retry", "trackFailure", "call", "Lokhttp3/internal/connection/RealCall;", "e", "Ljava/io/IOException;", "Companion", "okhttp"})
@SourceDebugExtension(value={"SMAP\nConnectPlan.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectPlan.kt\nokhttp3/internal/connection/ConnectPlan\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,563:1\n1#2:564\n*E\n"})
public final class ConnectPlan
implements RoutePlanner.Plan,
ExchangeCodec.Carrier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TaskRunner taskRunner;
    @NotNull
    private final RealConnectionPool connectionPool;
    private final int readTimeoutMillis;
    private final int writeTimeoutMillis;
    private final int socketConnectTimeoutMillis;
    private final int socketReadTimeoutMillis;
    private final int pingIntervalMillis;
    private final boolean retryOnConnectionFailure;
    @NotNull
    private final ConnectionUser user;
    @NotNull
    private final RealRoutePlanner routePlanner;
    @NotNull
    private final Route route;
    @Nullable
    private final List<Route> routes;
    private final int attempt;
    @Nullable
    private final Request tunnelRequest;
    private final int connectionSpecIndex;
    private final boolean isTlsFallback;
    private volatile boolean canceled;
    @Nullable
    private Socket rawSocket;
    @Nullable
    private Socket socket;
    @Nullable
    private Handshake handshake;
    @Nullable
    private Protocol protocol;
    @Nullable
    private BufferedSource source;
    @Nullable
    private BufferedSink sink;
    @Nullable
    private RealConnection connection;
    @NotNull
    private static final String NPE_THROW_WITH_NULL = "throw with null exception";
    private static final int MAX_TUNNEL_ATTEMPTS = 21;

    public ConnectPlan(@NotNull TaskRunner taskRunner, @NotNull RealConnectionPool connectionPool, int readTimeoutMillis, int writeTimeoutMillis, int socketConnectTimeoutMillis, int socketReadTimeoutMillis, int pingIntervalMillis, boolean retryOnConnectionFailure, @NotNull ConnectionUser user, @NotNull RealRoutePlanner routePlanner, @NotNull Route route, @Nullable List<Route> routes, int attempt, @Nullable Request tunnelRequest, int connectionSpecIndex, boolean isTlsFallback) {
        Intrinsics.checkNotNullParameter((Object)taskRunner, (String)"taskRunner");
        Intrinsics.checkNotNullParameter((Object)connectionPool, (String)"connectionPool");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)routePlanner, (String)"routePlanner");
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        this.taskRunner = taskRunner;
        this.connectionPool = connectionPool;
        this.readTimeoutMillis = readTimeoutMillis;
        this.writeTimeoutMillis = writeTimeoutMillis;
        this.socketConnectTimeoutMillis = socketConnectTimeoutMillis;
        this.socketReadTimeoutMillis = socketReadTimeoutMillis;
        this.pingIntervalMillis = pingIntervalMillis;
        this.retryOnConnectionFailure = retryOnConnectionFailure;
        this.user = user;
        this.routePlanner = routePlanner;
        this.route = route;
        this.routes = routes;
        this.attempt = attempt;
        this.tunnelRequest = tunnelRequest;
        this.connectionSpecIndex = connectionSpecIndex;
        this.isTlsFallback = isTlsFallback;
    }

    @Override
    @NotNull
    public Route getRoute() {
        return this.route;
    }

    @Nullable
    public final List<Route> getRoutes$okhttp() {
        return this.routes;
    }

    public final int getConnectionSpecIndex$okhttp() {
        return this.connectionSpecIndex;
    }

    public final boolean isTlsFallback$okhttp() {
        return this.isTlsFallback;
    }

    @Nullable
    public final Socket getSocket$okhttp() {
        return this.socket;
    }

    public final void setSocket$okhttp(@Nullable Socket socket) {
        this.socket = socket;
    }

    @Override
    public boolean isReady() {
        return this.protocol != null;
    }

    private final ConnectPlan copy(int attempt, Request tunnelRequest, int connectionSpecIndex, boolean isTlsFallback) {
        return new ConnectPlan(this.taskRunner, this.connectionPool, this.readTimeoutMillis, this.writeTimeoutMillis, this.socketConnectTimeoutMillis, this.socketReadTimeoutMillis, this.pingIntervalMillis, this.retryOnConnectionFailure, this.user, this.routePlanner, this.getRoute(), this.routes, attempt, tunnelRequest, connectionSpecIndex, isTlsFallback);
    }

    static /* synthetic */ ConnectPlan copy$default(ConnectPlan connectPlan, int n, Request request, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = connectPlan.attempt;
        }
        if ((n3 & 2) != 0) {
            request = connectPlan.tunnelRequest;
        }
        if ((n3 & 4) != 0) {
            n2 = connectPlan.connectionSpecIndex;
        }
        if ((n3 & 8) != 0) {
            bl = connectPlan.isTlsFallback;
        }
        return connectPlan.copy(n, request, n2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public RoutePlanner.ConnectResult connectTcp() {
        if (!(this.rawSocket == null)) {
            boolean $i$a$-check-ConnectPlan$connectTcp$22 = false;
            String $i$a$-check-ConnectPlan$connectTcp$22 = "TCP already connected";
            throw new IllegalStateException($i$a$-check-ConnectPlan$connectTcp$22.toString());
        }
        boolean success = false;
        this.user.addPlanToCancel(this);
        try {
            this.user.connectStart(this.getRoute());
            this.connectSocket();
            success = true;
            RoutePlanner.ConnectResult $i$a$-check-ConnectPlan$connectTcp$22 = new RoutePlanner.ConnectResult(this, null, null, 6, null);
            this.user.removePlanToCancel(this);
            return $i$a$-check-ConnectPlan$connectTcp$22;
        }
        catch (IOException e2) {
            this.user.connectFailed(this.getRoute(), null, e2);
            RoutePlanner.ConnectResult connectResult = new RoutePlanner.ConnectResult(this, null, e2, 2, null);
            return connectResult;
        }
        finally {
            block7: {
                this.user.removePlanToCancel(this);
                if (success) break block7;
                Socket socket = this.rawSocket;
                if (socket != null) {
                    _UtilJvmKt.closeQuietly(socket);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public RoutePlanner.ConnectResult connectTlsEtc() {
        RoutePlanner.ConnectResult connectResult;
        boolean success;
        block17: {
            if (!(this.rawSocket != null)) {
                boolean $i$a$-check-ConnectPlan$connectTlsEtc$32 = false;
                String $i$a$-check-ConnectPlan$connectTlsEtc$32 = "TCP not connected";
                throw new IllegalStateException($i$a$-check-ConnectPlan$connectTlsEtc$32.toString());
            }
            if (!(!this.isReady())) {
                boolean $i$a$-check-ConnectPlan$connectTlsEtc$42 = false;
                String $i$a$-check-ConnectPlan$connectTlsEtc$42 = "already connected";
                throw new IllegalStateException($i$a$-check-ConnectPlan$connectTlsEtc$42.toString());
            }
            List<ConnectionSpec> connectionSpecs = this.getRoute().address().connectionSpecs();
            ConnectPlan retryTlsConnection = null;
            success = false;
            this.user.addPlanToCancel(this);
            try {
                RealConnection connection;
                RoutePlanner.ConnectResult tunnelResult;
                if (this.tunnelRequest != null && ((tunnelResult = this.connectTunnel$okhttp()).getNextPlan() != null || tunnelResult.getThrowable() != null)) {
                    connectResult = tunnelResult;
                    this.user.removePlanToCancel(this);
                    break block17;
                }
                if (this.getRoute().address().sslSocketFactory() != null) {
                    BufferedSource bufferedSource = this.source;
                    if (bufferedSource != null && (bufferedSource = bufferedSource.getBuffer()) != null ? !((Buffer)bufferedSource).exhausted() : false) throw new IOException("TLS tunnel buffered too many bytes!");
                    BufferedSink bufferedSink = this.sink;
                    boolean bl = bufferedSink != null && (bufferedSink = bufferedSink.getBuffer()) != null ? !((Buffer)bufferedSink).exhausted() : false;
                    if (bl) {
                        throw new IOException("TLS tunnel buffered too many bytes!");
                    }
                    this.user.secureConnectStart();
                    Socket socket = this.getRoute().address().sslSocketFactory().createSocket(this.rawSocket, this.getRoute().address().url().host(), this.getRoute().address().url().port(), true);
                    Intrinsics.checkNotNull((Object)socket, (String)"null cannot be cast to non-null type javax.net.ssl.SSLSocket");
                    SSLSocket sslSocket = (SSLSocket)socket;
                    ConnectPlan tlsEquipPlan = this.planWithCurrentOrInitialConnectionSpec$okhttp(connectionSpecs, sslSocket);
                    ConnectionSpec connectionSpec = connectionSpecs.get(tlsEquipPlan.connectionSpecIndex);
                    retryTlsConnection = tlsEquipPlan.nextConnectionSpec$okhttp(connectionSpecs, sslSocket);
                    connectionSpec.apply$okhttp(sslSocket, tlsEquipPlan.isTlsFallback);
                    this.connectTls(sslSocket, connectionSpec);
                    this.user.secureConnectEnd(this.handshake);
                } else {
                    this.socket = this.rawSocket;
                    this.protocol = this.getRoute().address().protocols().contains((Object)Protocol.H2_PRIOR_KNOWLEDGE) ? Protocol.H2_PRIOR_KNOWLEDGE : Protocol.HTTP_1_1;
                }
                this.connection = connection = new RealConnection(this.taskRunner, this.connectionPool, this.getRoute(), this.rawSocket, this.socket, this.handshake, this.protocol, this.source, this.sink, this.pingIntervalMillis, this.connectionPool.getConnectionListener$okhttp());
                connection.start();
                this.user.callConnectEnd(this.getRoute(), this.protocol);
                success = true;
                RoutePlanner.ConnectResult connectResult2 = new RoutePlanner.ConnectResult(this, null, null, 6, null);
                this.user.removePlanToCancel(this);
                return connectResult2;
            }
            catch (IOException e2) {
                this.user.connectFailed(this.getRoute(), null, e2);
                if (!this.retryOnConnectionFailure || !RetryTlsHandshakeKt.retryTlsHandshake(e2)) {
                    retryTlsConnection = null;
                }
                RoutePlanner.ConnectResult connectResult3 = new RoutePlanner.ConnectResult(this, retryTlsConnection, e2);
                return connectResult3;
            }
        }
        Socket socket = this.socket;
        if (socket != null) {
            _UtilJvmKt.closeQuietly(socket);
        }
        Socket socket2 = this.rawSocket;
        if (socket2 == null) return connectResult;
        _UtilJvmKt.closeQuietly(socket2);
        return connectResult;
        finally {
            this.user.removePlanToCancel(this);
            if (!success) {
                Socket socket3 = this.socket;
                if (socket3 != null) {
                    _UtilJvmKt.closeQuietly(socket3);
                }
                Socket socket4 = this.rawSocket;
                if (socket4 != null) {
                    _UtilJvmKt.closeQuietly(socket4);
                }
            }
        }
    }

    private final void connectSocket() throws IOException {
        block8: {
            Socket rawSocket;
            Socket socket;
            Proxy.Type type = this.getRoute().proxy().type();
            switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: 
                case 2: {
                    Socket socket2 = this.getRoute().address().socketFactory().createSocket();
                    socket = socket2;
                    Intrinsics.checkNotNull((Object)socket2);
                    break;
                }
                default: {
                    socket = new Socket(this.getRoute().proxy());
                }
            }
            this.rawSocket = rawSocket = socket;
            if (this.canceled) {
                throw new IOException("canceled");
            }
            rawSocket.setSoTimeout(this.socketReadTimeoutMillis);
            try {
                Platform.Companion.get().connectSocket(rawSocket, this.getRoute().socketAddress(), this.socketConnectTimeoutMillis);
            }
            catch (ConnectException e2) {
                ConnectException connectException;
                ConnectException $this$connectSocket_u24lambda_u243 = connectException = new ConnectException("Failed to connect to " + this.getRoute().socketAddress());
                boolean bl = false;
                $this$connectSocket_u24lambda_u243.initCause(e2);
                throw (Throwable)connectException;
            }
            try {
                this.source = Okio.buffer(Okio.source(rawSocket));
                this.sink = Okio.buffer(Okio.sink(rawSocket));
            }
            catch (NullPointerException npe) {
                if (!Intrinsics.areEqual((Object)npe.getMessage(), (Object)NPE_THROW_WITH_NULL)) break block8;
                throw new IOException(npe);
            }
        }
    }

    @NotNull
    public final RoutePlanner.ConnectResult connectTunnel$okhttp() throws IOException {
        Request request = this.createTunnel();
        if (request == null) {
            return new RoutePlanner.ConnectResult(this, null, null, 6, null);
        }
        Request nextTunnelRequest = request;
        Socket socket = this.rawSocket;
        if (socket != null) {
            _UtilJvmKt.closeQuietly(socket);
        }
        int nextAttempt = this.attempt + 1;
        if (nextAttempt >= 21) {
            ProtocolException failure = new ProtocolException("Too many tunnel connections attempted: 21");
            this.user.connectFailed(this.getRoute(), null, failure);
            return new RoutePlanner.ConnectResult(this, null, failure, 2, null);
        }
        this.user.callConnectEnd(this.getRoute(), null);
        return new RoutePlanner.ConnectResult(this, ConnectPlan.copy$default(this, nextAttempt, nextTunnelRequest, 0, false, 12, null), null, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void connectTls(SSLSocket sslSocket, ConnectionSpec connectionSpec) throws IOException {
        Address address = this.getRoute().address();
        boolean success = false;
        try {
            Handshake handshake2;
            if (connectionSpec.supportsTlsExtensions()) {
                Platform.Companion.get().configureTlsExtensions(sslSocket, address.url().host(), address.protocols());
            }
            sslSocket.startHandshake();
            SSLSession sslSocketSession = sslSocket.getSession();
            Intrinsics.checkNotNull((Object)sslSocketSession);
            Handshake unverifiedHandshake = Handshake.Companion.get(sslSocketSession);
            HostnameVerifier hostnameVerifier = address.hostnameVerifier();
            Intrinsics.checkNotNull((Object)hostnameVerifier);
            if (!hostnameVerifier.verify(address.url().host(), sslSocketSession)) {
                List<Certificate> peerCertificates2 = unverifiedHandshake.peerCertificates();
                if (!((Collection)peerCertificates2).isEmpty()) {
                    Certificate certificate = peerCertificates2.get(0);
                    Intrinsics.checkNotNull((Object)certificate, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
                    X509Certificate cert = (X509Certificate)certificate;
                    throw new SSLPeerUnverifiedException(StringsKt.trimMargin$default((String)("\n            |Hostname " + address.url().host() + " not verified:\n            |    certificate: " + CertificatePinner.Companion.pin(cert) + "\n            |    DN: " + cert.getSubjectDN().getName() + "\n            |    subjectAltNames: " + OkHostnameVerifier.INSTANCE.allSubjectAltNames(cert) + "\n            "), null, (int)1, null));
                }
                throw new SSLPeerUnverifiedException("Hostname " + address.url().host() + " not verified (no certificates)");
            }
            CertificatePinner certificatePinner = address.certificatePinner();
            Intrinsics.checkNotNull((Object)certificatePinner);
            CertificatePinner certificatePinner2 = certificatePinner;
            this.handshake = handshake2 = new Handshake(unverifiedHandshake.tlsVersion(), unverifiedHandshake.cipherSuite(), unverifiedHandshake.localCertificates(), (Function0<? extends List<? extends Certificate>>)((Function0)new Function0<List<? extends Certificate>>(certificatePinner2, unverifiedHandshake, address){
                final /* synthetic */ CertificatePinner $certificatePinner;
                final /* synthetic */ Handshake $unverifiedHandshake;
                final /* synthetic */ Address $address;
                {
                    this.$certificatePinner = $certificatePinner;
                    this.$unverifiedHandshake = $unverifiedHandshake;
                    this.$address = $address;
                    super(0);
                }

                @NotNull
                public final List<Certificate> invoke() {
                    CertificateChainCleaner certificateChainCleaner = this.$certificatePinner.getCertificateChainCleaner$okhttp();
                    Intrinsics.checkNotNull((Object)certificateChainCleaner);
                    return certificateChainCleaner.clean(this.$unverifiedHandshake.peerCertificates(), this.$address.url().host());
                }
            }));
            certificatePinner2.check$okhttp(address.url().host(), (Function0<? extends List<? extends X509Certificate>>)((Function0)new Function0<List<? extends X509Certificate>>(handshake2){
                final /* synthetic */ Handshake $handshake;
                {
                    this.$handshake = $handshake;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<X509Certificate> invoke() {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = this.$handshake.peerCertificates();
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Certificate certificate = (Certificate)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
                        collection.add((X509Certificate)it);
                    }
                    return (List)destination$iv$iv;
                }
            }));
            String maybeProtocol = connectionSpec.supportsTlsExtensions() ? Platform.Companion.get().getSelectedProtocol(sslSocket) : null;
            this.socket = sslSocket;
            this.source = Okio.buffer(Okio.source(sslSocket));
            this.sink = Okio.buffer(Okio.sink(sslSocket));
            String string2 = maybeProtocol;
            this.protocol = string2 != null ? Protocol.Companion.get(string2) : Protocol.HTTP_1_1;
            success = true;
            Platform.Companion.get().afterHandshake(sslSocket);
        }
        catch (Throwable throwable) {
            Platform.Companion.get().afterHandshake(sslSocket);
            _UtilJvmKt.closeQuietly(sslSocket);
            throw throwable;
        }
    }

    private final Request createTunnel() throws IOException {
        Response response;
        Request request = this.tunnelRequest;
        Intrinsics.checkNotNull((Object)request);
        Request nextRequest = request;
        HttpUrl url = this.getRoute().address().url();
        String requestLine = "CONNECT " + _UtilJvmKt.toHostHeader(url, true) + " HTTP/1.1";
        block4: while (true) {
            BufferedSink sink2;
            BufferedSource source2;
            Intrinsics.checkNotNull((Object)this.source);
            Intrinsics.checkNotNull((Object)this.sink);
            Http1ExchangeCodec tunnelCodec = new Http1ExchangeCodec(null, this, source2, sink2);
            source2.timeout().timeout(this.readTimeoutMillis, TimeUnit.MILLISECONDS);
            sink2.timeout().timeout(this.writeTimeoutMillis, TimeUnit.MILLISECONDS);
            tunnelCodec.writeRequest(nextRequest.headers(), requestLine);
            tunnelCodec.finishRequest();
            Response.Builder builder = tunnelCodec.readResponseHeaders(false);
            Intrinsics.checkNotNull((Object)builder);
            response = builder.request(nextRequest).build();
            tunnelCodec.skipConnectBody(response);
            switch (response.code()) {
                case 200: {
                    return null;
                }
                case 407: {
                    if (this.getRoute().address().proxyAuthenticator().authenticate(this.getRoute(), response) != null) continue block4;
                    throw new IOException("Failed to authenticate with proxy");
                    if (!StringsKt.equals((String)"close", (String)Response.header$default(response, "Connection", null, 2, null), (boolean)true)) continue block4;
                    return nextRequest;
                }
            }
            break;
        }
        throw new IOException("Unexpected response code for CONNECT: " + response.code());
    }

    @NotNull
    public final ConnectPlan planWithCurrentOrInitialConnectionSpec$okhttp(@NotNull List<ConnectionSpec> connectionSpecs, @NotNull SSLSocket sslSocket) throws IOException {
        Intrinsics.checkNotNullParameter(connectionSpecs, (String)"connectionSpecs");
        Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
        if (this.connectionSpecIndex != -1) {
            return this;
        }
        ConnectPlan connectPlan = this.nextConnectionSpec$okhttp(connectionSpecs, sslSocket);
        if (connectPlan == null) {
            StringBuilder stringBuilder = new StringBuilder().append("Unable to find acceptable protocols. isFallback=").append(this.isTlsFallback).append(", modes=").append(connectionSpecs).append(", supported protocols=");
            Object[] objectArray = sslSocket.getEnabledProtocols();
            Intrinsics.checkNotNull((Object)objectArray);
            String string2 = Arrays.toString(objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            throw new UnknownServiceException(stringBuilder.append(string2).toString());
        }
        return connectPlan;
    }

    @Nullable
    public final ConnectPlan nextConnectionSpec$okhttp(@NotNull List<ConnectionSpec> connectionSpecs, @NotNull SSLSocket sslSocket) {
        Intrinsics.checkNotNullParameter(connectionSpecs, (String)"connectionSpecs");
        Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
        int n = connectionSpecs.size();
        for (int i2 = this.connectionSpecIndex + 1; i2 < n; ++i2) {
            if (!connectionSpecs.get(i2).isCompatible(sslSocket)) continue;
            return ConnectPlan.copy$default(this, 0, null, i2, this.connectionSpecIndex != -1, 3, null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public RealConnection handleSuccess() {
        this.user.updateRouteDatabaseAfterSuccess(this.getRoute());
        RealConnection realConnection = this.connection;
        Intrinsics.checkNotNull((Object)realConnection);
        RealConnection connection = realConnection;
        this.user.connectionConnectEnd(connection, this.getRoute());
        ReusePlan pooled3 = this.routePlanner.planReusePooledConnection$okhttp(this, this.routes);
        if (pooled3 != null) {
            return pooled3.getConnection();
        }
        RealConnection realConnection2 = connection;
        synchronized (realConnection2) {
            boolean bl = false;
            this.connectionPool.put(connection);
            this.user.acquireConnectionNoEvents(connection);
            Unit unit = Unit.INSTANCE;
        }
        this.user.connectionAcquired(connection);
        this.user.connectionConnectionAcquired(connection);
        return connection;
    }

    @Override
    public void trackFailure(@NotNull RealCall call2, @Nullable IOException e2) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
    }

    @Override
    public void noNewExchanges() {
    }

    @Override
    public void cancel() {
        block0: {
            this.canceled = true;
            Socket socket = this.rawSocket;
            if (socket == null) break block0;
            _UtilJvmKt.closeQuietly(socket);
        }
    }

    @Override
    @NotNull
    public RoutePlanner.Plan retry() {
        return new ConnectPlan(this.taskRunner, this.connectionPool, this.readTimeoutMillis, this.writeTimeoutMillis, this.socketConnectTimeoutMillis, this.socketReadTimeoutMillis, this.pingIntervalMillis, this.retryOnConnectionFailure, this.user, this.routePlanner, this.getRoute(), this.routes, this.attempt, this.tunnelRequest, this.connectionSpecIndex, this.isTlsFallback);
    }

    public final void closeQuietly() {
        block0: {
            Socket socket = this.socket;
            if (socket == null) break block0;
            _UtilJvmKt.closeQuietly(socket);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lokhttp3/internal/connection/ConnectPlan$Companion;", "", "()V", "MAX_TUNNEL_ATTEMPTS", "", "NPE_THROW_WITH_NULL", "", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Proxy.Type.values().length];
            try {
                nArray[Proxy.Type.DIRECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Proxy.Type.HTTP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

