/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridFilteringModel;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridSortingModel;
import com.intellij.database.util.DataSourceUtilBase;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.EventDispatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GridDataHookUpBase<Row, Column>
implements GridDataHookUp<Row, Column> {
    private final Project myProject;
    private final EventDispatcher<GridDataHookUp.RequestListener<Row, Column>> myRequestEventDispatcher;

    protected GridDataHookUpBase(@NotNull Project project) {
        if (project == null) {
            GridDataHookUpBase.$$$reportNull$$$0(0);
        }
        this.myRequestEventDispatcher = DataSourceUtilBase.eventDispatcher(GridDataHookUp.RequestListener.class);
        this.myProject = project;
    }

    @Override
    public void addRequestListener(@NotNull GridDataHookUp.RequestListener<Row, Column> listener, @NotNull Disposable disposable) {
        if (listener == null) {
            GridDataHookUpBase.$$$reportNull$$$0(1);
        }
        if (disposable == null) {
            GridDataHookUpBase.$$$reportNull$$$0(2);
        }
        this.myRequestEventDispatcher.addListener(listener, disposable);
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            GridDataHookUpBase.$$$reportNull$$$0(3);
        }
        return project;
    }

    @Override
    public void updateFilterSortFully() {
    }

    @Override
    public boolean isFilterApplicable() {
        return false;
    }

    @Override
    @NotNull
    public Language getFilterSortLanguage() {
        PlainTextLanguage plainTextLanguage = PlainTextLanguage.INSTANCE;
        if (plainTextLanguage == null) {
            GridDataHookUpBase.$$$reportNull$$$0(4);
        }
        return plainTextLanguage;
    }

    @Override
    @NotNull
    public String getFilterPrefix() {
        return "";
    }

    @Override
    @NotNull
    public String getFilterEmptyText() {
        return "";
    }

    @Override
    @Nullable
    public GridFilteringModel getFilteringModel() {
        return null;
    }

    @Override
    @NotNull
    public String getSortingPrefix() {
        return "";
    }

    @Override
    @NotNull
    public String getSortingEmptyText() {
        return "";
    }

    @Override
    @Nullable
    public GridSortingModel<Row, Column> getSortingModel() {
        return null;
    }

    @Override
    @Nullable
    public GridMutator<Row, Column> getMutator() {
        return null;
    }

    @Override
    public int getBusyCount() {
        return 0;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public void notifyRequestStarted(@NotNull GridRequestSource source) {
        if (source == null) {
            GridDataHookUpBase.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().invokeLater(() -> ((GridDataHookUp.RequestListener)this.myRequestEventDispatcher.getMulticaster()).requestStarted(source));
    }

    public void notifyRequestFinished(@NotNull GridRequestSource source, boolean success) {
        if (source == null) {
            GridDataHookUpBase.$$$reportNull$$$0(6);
        }
        source.requestComplete(success);
        ApplicationManager.getApplication().invokeLater(() -> ((GridDataHookUp.RequestListener)this.myRequestEventDispatcher.getMulticaster()).requestFinished(source, success));
    }

    public void notifyRequestProgress(@NotNull GridRequestSource source, @NlsContexts.ProgressText @Nullable String progress) {
        if (source == null) {
            GridDataHookUpBase.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().invokeLater(() -> ((GridDataHookUp.RequestListener)this.myRequestEventDispatcher.getMulticaster()).requestProgress(source, progress));
    }

    public void notifyRequestError(@NotNull GridRequestSource source, @NotNull ErrorInfo errorInfo) {
        if (source == null) {
            GridDataHookUpBase.$$$reportNull$$$0(8);
        }
        if (errorInfo == null) {
            GridDataHookUpBase.$$$reportNull$$$0(9);
        }
        source.setErrorOccurred(errorInfo.getMessage());
        ApplicationManager.getApplication().invokeLater(() -> ((GridDataHookUp.RequestListener)this.myRequestEventDispatcher.getMulticaster()).error(source, errorInfo));
    }

    public void notifyUpdateCountReceived(@NotNull GridRequestSource source, int updateCount) {
        if (source == null) {
            GridDataHookUpBase.$$$reportNull$$$0(10);
        }
        ApplicationManager.getApplication().invokeLater(() -> ((GridDataHookUp.RequestListener)this.myRequestEventDispatcher.getMulticaster()).updateCountReceived(source, updateCount));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/GridDataHookUpBase";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/GridDataHookUpBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterSortLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addRequestListener";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "notifyRequestStarted";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "notifyRequestFinished";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "notifyRequestProgress";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "notifyRequestError";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "notifyUpdateCountReceived";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

