/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.utils;

import ai.grazie.nlp.utils.WhiteSpacesKt;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.utils.Text;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0003\u001a\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u001a\u0014\u0010\f\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\nH\u0007\u001a\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006\u001a$\u0010\u0013\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u0012\u0010\u0017\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u001a\u0012\u0010\u0018\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u000e\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u000f\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"anyTag", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "closingTag", "commonBlockElements", "", "", "commonMarkupElements", "excludeHtml", "", "Lcom/intellij/grazie/text/TextContent;", "content", "removeHtml", "_content", "nbsp", "tab", "isSpaceEntity", "", "text", "inlineEntity", "pattern", "space", "", "inlineSpaceEntities", "nbspToSpace", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nHtmlUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HtmlUtils.kt\ncom/intellij/grazie/utils/HtmlUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n1#2:126\n1#2:137\n1617#3,9:127\n1869#3:136\n1870#3:138\n1626#3:139\n388#3,7:140\n*S KotlinDebug\n*F\n+ 1 HtmlUtils.kt\ncom/intellij/grazie/utils/HtmlUtilsKt\n*L\n46#1:137\n46#1:127,9\n46#1:136\n46#1:138\n46#1:139\n70#1:140,7\n*E\n"})
public final class HtmlUtilsKt {
    private static final Pattern anyTag = Pattern.compile("</?(\\w+)[^>]*>");
    private static final Pattern closingTag = Pattern.compile("</\\w+\\s*>");
    @JvmField
    @NotNull
    public static final Set<String> commonBlockElements;
    @NotNull
    private static final Set<String> commonMarkupElements;
    private static final Pattern nbsp;
    private static final Pattern tab;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TextContent> excludeHtml(@Nullable TextContent content) {
        void $this$mapNotNullTo$iv$iv;
        Object p0;
        if (content == null) {
            return CollectionsKt.emptyList();
        }
        ArrayList<TextContent> components = new ArrayList<TextContent>();
        int lastComponentStart = 0;
        int matchEnd = 0;
        Matcher matcher = anyTag.matcher(content);
        while (matcher.find(matchEnd)) {
            matchEnd = matcher.end();
            ProgressManager.checkCanceled();
            String tagName = matcher.group(1);
            if (!commonBlockElements.contains(tagName)) continue;
            if (content.subText(new TextRange(lastComponentStart, matcher.start())) != null) {
                TextContent p02;
                boolean bl = false;
                components.add(p02);
            }
            lastComponentStart = matcher.end();
        }
        TextContent textContent = content.subText(new TextRange(lastComponentStart, content.length()));
        if (textContent != null) {
            p0 = textContent;
            boolean bl = false;
            components.add((TextContent)p0);
        }
        Iterable $this$mapNotNull$iv = components;
        boolean $i$f$mapNotNull = false;
        p0 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            TextContent it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            TextContent it = (TextContent)element$iv$iv;
            boolean bl2 = false;
            TextContent textContent2 = HtmlUtilsKt.removeHtml(it);
            if ((textContent2 != null ? textContent2.trimWhitespace() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Deprecated(message="use excludeHtml", replaceWith=@ReplaceWith(expression="excludeHtml", imports={}))
    @Nullable
    public static final TextContent removeHtml(@Nullable TextContent _content) {
        Ref.ObjectRef content = new Ref.ObjectRef();
        TextContent textContent = _content;
        if (textContent == null) {
            return null;
        }
        content.element = textContent;
        while (StringsKt.startsWith$default((CharSequence)((CharSequence)content.element), (CharSequence)"<html>", (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)((CharSequence)content.element), (CharSequence)"<body>", (boolean)false, (int)2, null)) {
            Intrinsics.checkNotNullExpressionValue((Object)((TextContent)content.element).excludeRange(new TextRange(0, 6)), (String)"excludeRange(...)");
            content.element = content.element;
        }
        while (StringsKt.endsWith$default((CharSequence)((CharSequence)content.element), (CharSequence)"</html>", (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)((CharSequence)content.element), (CharSequence)"</body>", (boolean)false, (int)2, null)) {
            Intrinsics.checkNotNullExpressionValue((Object)((TextContent)content.element).excludeRange(TextRange.from((int)(((TextContent)content.element).length() - 7), (int)7)), (String)"excludeRange(...)");
            content.element = content.element;
        }
        ArrayList<TextContent.Exclusion> exclusions2 = new ArrayList<TextContent.Exclusion>();
        int matchEnd = 0;
        Matcher matcher = anyTag.matcher((CharSequence)content.element);
        while (matcher.find(matchEnd)) {
            TextContent.ExclusionKind exclusionKind;
            matchEnd = matcher.end();
            ProgressManager.checkCanceled();
            int matchStart = matcher.start();
            String tagName = matcher.group(1);
            if (!Character.isLetterOrDigit(tagName.charAt(0))) continue;
            TextContent.ExclusionKind exclusionKind2 = exclusionKind = commonMarkupElements.contains(tagName) ? TextContent.ExclusionKind.markup : TextContent.ExclusionKind.unknown;
            if (closingTag.matcher(((TextContent)content.element).subSequence(matchStart, matchEnd)).matches()) {
                exclusions2.add(new TextContent.Exclusion(matchStart, matchEnd, exclusionKind));
                HtmlUtilsKt.removeHtml$tagClosed(exclusions2, (Ref.ObjectRef<TextContent>)content, ((Object)StringsKt.trim((CharSequence)((Object)((CharSequence)content.element).subSequence(matchStart + 2, matchEnd - 1)).toString())).toString());
                continue;
            }
            exclusions2.add(new TextContent.Exclusion(matchStart, matchEnd, exclusionKind));
        }
        return ((TextContent)content.element).excludeRanges((List<TextContent.Exclusion>)exclusions2);
    }

    public static final boolean isSpaceEntity(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return Intrinsics.areEqual((Object)text, (Object)nbsp.pattern()) || Intrinsics.areEqual((Object)text, (Object)tab.pattern());
    }

    private static final TextContent inlineEntity(TextContent content, Pattern pattern, char space) {
        if (content == null) {
            return null;
        }
        List<TextRange> spaces = Text.allOccurrences(pattern, content);
        if (spaces.isEmpty()) {
            return content.trimWhitespace();
        }
        ArrayList<TextContent> components = new ArrayList<TextContent>();
        int n = ((Collection)spaces).size();
        for (int i = 0; i < n; ++i) {
            int prevEnd = i == 0 ? 0 : spaces.get(i - 1).getEndOffset();
            TextContent textContent = content.subText(new TextRange(prevEnd, spaces.get(i).getStartOffset()));
            components.add(textContent != null ? textContent.trimWhitespace() : null);
        }
        TextContent textContent = content.subText(new TextRange(((TextRange)CollectionsKt.last(spaces)).getEndOffset(), content.length()));
        components.add(textContent != null ? textContent.trimWhitespace() : null);
        return TextContent.joinWithWhitespace(space, CollectionsKt.filterNotNull((Iterable)components));
    }

    @Nullable
    public static final TextContent inlineSpaceEntities(@Nullable TextContent content) {
        TextContent textContent = HtmlUtilsKt.nbspToSpace(content);
        Pattern pattern = tab;
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"tab");
        return HtmlUtilsKt.inlineEntity(textContent, pattern, '\t');
    }

    @Nullable
    public static final TextContent nbspToSpace(@Nullable TextContent content) {
        Pattern pattern = nbsp;
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"nbsp");
        return HtmlUtilsKt.inlineEntity(content, pattern, '\u00a0');
    }

    private static final String removeHtml$openingTagName(Ref.ObjectRef<TextContent> content, int tagRangeStart, int tagRangeEnd) {
        return Character.isLetter(((TextContent)content.element).charAt(tagRangeStart + 1)) ? WhiteSpacesKt.takeNonWhitespaces((String)((Object)((CharSequence)content.element).subSequence(tagRangeStart + 1, tagRangeEnd - 1)).toString()) : null;
    }

    private static final void removeHtml$tagClosed(ArrayList<TextContent.Exclusion> exclusions2, Ref.ObjectRef<TextContent> content, String tagName) {
        int openingIndex;
        block3: {
            int n;
            if (commonMarkupElements.contains(tagName)) {
                return;
            }
            List $this$indexOfLast$iv = exclusions2;
            boolean $i$f$indexOfLast = false;
            ListIterator iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                TextContent.Exclusion it = (TextContent.Exclusion)iterator$iv.previous();
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)HtmlUtilsKt.removeHtml$openingTagName(content, it.start, it.end), (Object)tagName) && ((TextContent)content.element).charAt(it.end - 2) != '/')) continue;
                n = iterator$iv.nextIndex();
                break block3;
            }
            n = openingIndex = -1;
        }
        if (openingIndex >= 0) {
            exclusions2.set(openingIndex, TextContent.Exclusion.markUnknown(new TextRange(exclusions2.get((int)openingIndex).start, ((TextContent.Exclusion)CollectionsKt.last((List)((List)exclusions2))).end)));
            exclusions2.subList(openingIndex + 1, exclusions2.size()).clear();
        }
    }

    static {
        Object[] objectArray = new String[]{"body", "p", "br", "td", "li", "title", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "table", "ol", "ul", "pre"};
        commonBlockElements = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"span", "i", "b", "u", "font", "a", "s", "strong", "sub", "sup"};
        commonMarkupElements = SetsKt.setOf((Object[])objectArray);
        nbsp = Pattern.compile("&nbsp;");
        tab = Pattern.compile("&#9;");
    }
}

