/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.text;

import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextProblem;
import com.intellij.lang.LanguageExtension;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public abstract class ProblemFilter {
    private static final LanguageExtension<ProblemFilter> EP = new LanguageExtension("com.intellij.grazie.problemFilter");

    public static Stream<ProblemFilter> allIgnoringFilters(TextProblem problem) {
        return EP.allForLanguageOrAny(problem.getText().getCommonParent().getLanguage()).stream().filter(f -> f.shouldIgnore(problem));
    }

    public static Stream<ProblemFilter> allIgnoringFilters(TextContent content) {
        return EP.allForLanguageOrAny(content.getCommonParent().getLanguage()).stream().filter(f -> f.shouldIgnore(content));
    }

    public abstract boolean shouldIgnore(@NotNull TextProblem var1);

    public boolean shouldIgnore(@NotNull TextContent content) {
        if (content == null) {
            ProblemFilter.$$$reportNull$$$0(0);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/grazie/text/ProblemFilter", "shouldIgnore"));
    }
}

