/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.ConnectorImpl;
import com.jetbrains.jdi.SharedMemoryAttachingConnector;
import com.jetbrains.jdi.SocketTransportService;
import com.jetbrains.jdi.VirtualMachineManagerImpl;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.Transport;
import com.sun.jdi.connect.spi.Connection;
import com.sun.jdi.connect.spi.TransportService;
import com.sun.tools.attach.VirtualMachine;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class ProcessAttachingConnector
extends ConnectorImpl
implements AttachingConnector {
    static final String ARG_PID = "pid";
    static final String ARG_TIMEOUT = "timeout";
    VirtualMachine vm;
    final Transport transport;

    public ProcessAttachingConnector() {
        this.addStringArgument(ARG_PID, this.getString("process_attaching.pid.label"), this.getString("process_attaching.pid"), "", true);
        this.addIntegerArgument(ARG_TIMEOUT, this.getString("generic_attaching.timeout.label"), this.getString("generic_attaching.timeout"), "", false, 0, Integer.MAX_VALUE);
        this.transport = () -> "local";
    }

    @Override
    public com.sun.jdi.VirtualMachine attach(Map<String, ? extends Connector.Argument> args) throws IOException, IllegalConnectorArgumentsException {
        String address;
        String pid = this.argument(ARG_PID, args).value();
        String t = this.argument(ARG_TIMEOUT, args).value();
        int timeout = 0;
        if (t.length() > 0) {
            timeout = Integer.decode(t);
        }
        VirtualMachine vm = null;
        try {
            vm = VirtualMachine.attach(pid);
            Properties props = vm.getAgentProperties();
            address = props.getProperty("sun.jdwp.listenerAddress");
        }
        catch (Exception x) {
            throw new IOException(x);
        }
        finally {
            if (vm != null) {
                vm.detach();
            }
        }
        if (address == null) {
            throw new IOException("Not a debuggee, or not listening for debugger to attach");
        }
        int pos = address.indexOf(58);
        if (pos < 1) {
            throw new IOException("Unable to determine transport endpoint");
        }
        String lib = address.substring(0, pos);
        address = address.substring(pos + 1);
        TransportService ts = null;
        if (lib.equals("dt_socket")) {
            ts = new SocketTransportService();
        } else if (lib.equals("dt_shmem")) {
            try {
                ts = SharedMemoryAttachingConnector.createSharedMemoryTransportService();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (ts == null) {
            throw new IOException("Transport " + lib + " not recognized");
        }
        Connection connection = ts.attach(address, timeout, 0L);
        return VirtualMachineManagerImpl.virtualMachineManager().createVirtualMachine(connection);
    }

    @Override
    public String name() {
        return VirtualMachineManagerImpl.connectorName("com.jetbrains.jdi.ProcessAttach");
    }

    @Override
    public String description() {
        return this.getString("process_attaching.description");
    }

    @Override
    public Transport transport() {
        if (this.transport == null) {
            return () -> "local";
        }
        return this.transport;
    }
}

