/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradle.statistics.v2.flow;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.gradle.statistics.v2.flow.AggregatedFusMetric;
import org.jetbrains.kotlin.idea.gradle.statistics.v2.flow.FusFlowSendingStep;
import org.jetbrains.kotlin.idea.gradle.statistics.v2.flow.KotlinBuildToolEventsKt;
import org.jetbrains.kotlin.idea.gradle.statistics.v2.flow.KotlinBuildToolFusFlowCollector;
import org.jetbrains.kotlin.idea.gradle.statistics.v2.flow.KotlinBuildToolFusMetric;
import org.jetbrains.kotlin.idea.gradle.statistics.v2.flow.KotlinBuildToolsMetricsKt;
import org.jetbrains.kotlin.idea.gradle.statistics.v2.flow.RawFusValue;
import org.jetbrains.kotlin.idea.gradle.statistics.v2.flow.RawMetricsForBuild;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\fJ \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000e2\u0006\u0010\u000b\u001a\u00020\u0005J\u001c\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ&\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u00152\u0006\u0010\u0012\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J\u0016\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u0015*\u00020\u0018H\u0002J\u0014\u0010\u001b\u001a\u00020\u0018*\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/gradle/statistics/v2/flow/KotlinBuildToolFusFlowProcessor;", "", "<init>", "()V", "STATISTICS_FOLDER_NAME", "", "FILE_NAME_BUILD_ID_PREFIX_SEPARATOR", "fusFileExtensionsGlob", "BUILD_FINISHED_FUS_FILE_EXTENSION", "process", "", "gradleUserHome", "process$kotlin_gradle_gradle", "filterFilesToRead", "", "", "Ljava/nio/file/Path;", "processFilesForBuildId", "buildId", "listFiles", "aggregateMetricsForBuildId", "", "Lorg/jetbrains/kotlin/idea/gradle/statistics/v2/flow/AggregatedFusMetric;", "readFile", "Lorg/jetbrains/kotlin/idea/gradle/statistics/v2/flow/RawMetricsForBuild;", "path", "aggregateMetrics", "add", "rawMetricsForBuild", "kotlin.gradle.gradle"})
@SourceDebugExtension(value={"SMAP\nKotlinBuildToolFusFlowProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinBuildToolFusFlowProcessor.kt\norg/jetbrains/kotlin/idea/gradle/statistics/v2/flow/KotlinBuildToolFusFlowProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,138:1\n1193#2,2:139\n1267#2,2:141\n774#2:143\n865#2,2:144\n1270#2:146\n1869#2,2:147\n1617#2,9:149\n1869#2:158\n1870#2:160\n1626#2:161\n2851#2,7:162\n1869#2,2:191\n774#2:193\n865#2,2:194\n1#3:159\n1#3:179\n136#4,9:169\n216#4:178\n217#4:180\n145#4:181\n216#4:182\n217#4:190\n382#5,7:183\n382#5,7:196\n*S KotlinDebug\n*F\n+ 1 KotlinBuildToolFusFlowProcessor.kt\norg/jetbrains/kotlin/idea/gradle/statistics/v2/flow/KotlinBuildToolFusFlowProcessor\n*L\n55#1:139,2\n55#1:141,2\n59#1:143\n59#1:144,2\n55#1:146\n65#1:147,2\n71#1:149,9\n71#1:158\n71#1:160\n71#1:161\n79#1:162,7\n44#1:191,2\n100#1:193\n100#1:194,2\n71#1:159\n113#1:179\n113#1:169,9\n113#1:178\n113#1:180\n113#1:181\n123#1:182\n123#1:190\n124#1:183,7\n103#1:196,7\n*E\n"})
public final class KotlinBuildToolFusFlowProcessor {
    @NotNull
    public static final KotlinBuildToolFusFlowProcessor INSTANCE = new KotlinBuildToolFusFlowProcessor();
    @NotNull
    private static final String STATISTICS_FOLDER_NAME = "kotlin-profile";
    @NotNull
    private static final String FILE_NAME_BUILD_ID_PREFIX_SEPARATOR = ".";
    @NotNull
    private static final String fusFileExtensionsGlob;
    @NotNull
    private static final String BUILD_FINISHED_FUS_FILE_EXTENSION = "finish-profile";

    private KotlinBuildToolFusFlowProcessor() {
    }

    public final void process$kotlin_gradle_gradle(@NotNull String gradleUserHome) {
        Intrinsics.checkNotNullParameter((Object)gradleUserHome, (String)"gradleUserHome");
        try {
            Map<String, List<Path>> pathsByBuildId = this.filterFilesToRead(gradleUserHome);
            pathsByBuildId.forEach((arg_0, arg_1) -> KotlinBuildToolFusFlowProcessor.process$lambda$2(KotlinBuildToolFusFlowProcessor::process$lambda$1, arg_0, arg_1));
        }
        catch (Exception e) {
            Logger.getInstance(KotlinBuildToolFusFlowProcessor.class).warn("Failed to process " + gradleUserHome + " directory: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, List<Path>> filterFilesToRead(@NotNull String gradleUserHome) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)gradleUserHome, (String)"gradleUserHome");
        String[] stringArray = new String[]{STATISTICS_FOLDER_NAME};
        Path path2 = Paths.get(gradleUserHome, Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        Path staticFolder = path2;
        List buildFinishFiles = PathsKt.listDirectoryEntries((Path)staticFolder, (String)"*.finish-profile");
        Iterable $this$associate$iv = buildFinishFiles;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Path it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Map map2 = destination$iv$iv;
            Path buildFinishFile = (Path)element$iv$iv;
            boolean bl = false;
            String buildId = StringsKt.substringBefore$default((String)((Object)buildFinishFile.getFileName()).toString(), (String)".finish-profile", null, (int)2, null);
            Object object = new String[]{STATISTICS_FOLDER_NAME};
            Path path3 = Paths.get(gradleUserHome, Arrays.copyOf(object, ((String[])object).length));
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
            object = PathsKt.listDirectoryEntries((Path)path3, (String)fusFileExtensionsGlob);
            boolean $i$f$filter = false;
            void var18_18 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                it = (Path)element$iv$iv2;
                boolean bl2 = false;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv2 = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                it = (Path)element$iv$iv2;
                boolean bl3 = false;
                if (!StringsKt.startsWith$default((String)((Object)it.getFileName()).toString(), (String)buildId, (boolean)false, (int)2, null)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            List fusFiles = (List)destination$iv$iv2;
            Pair pair = TuplesKt.to((Object)buildId, (Object)CollectionsKt.plus((Collection)fusFiles, (Iterable)CollectionsKt.listOf((Object)buildFinishFile)));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    public final void processFilesForBuildId(@NotNull String buildId, @NotNull List<? extends Path> listFiles) {
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        Intrinsics.checkNotNullParameter(listFiles, (String)"listFiles");
        Iterable $this$forEach$iv = KotlinBuildToolEventsKt.getKotlinBuildToolsFusEvenList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FusFlowSendingStep it = (FusFlowSendingStep)element$iv;
            boolean bl = false;
            KotlinBuildToolFusFlowCollector.INSTANCE.send(it, buildId, INSTANCE.aggregateMetricsForBuildId(buildId, listFiles));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<AggregatedFusMetric<?>> aggregateMetricsForBuildId(@NotNull String buildId, @NotNull List<? extends Path> listFiles) {
        Set<AggregatedFusMetric<?>> set;
        Object v1;
        void $this$reduceOrNull$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        Intrinsics.checkNotNullParameter(listFiles, (String)"listFiles");
        Iterable $this$mapNotNull$iv = listFiles;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            RawMetricsForBuild rawMetricsForBuild;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Path it = (Path)element$iv$iv;
            boolean bl2 = false;
            RawMetricsForBuild rawMetricsForBuild2 = INSTANCE.readFile(it);
            if (!Intrinsics.areEqual((Object)rawMetricsForBuild2.getBuildId(), (Object)buildId)) {
                Logger.getInstance(KotlinBuildToolFusFlowProcessor.class).warn("File " + it.getFileName() + " contains data for buildId `" + rawMetricsForBuild2.getBuildId() + "`, but build `" + buildId + "` was expected. Skipping file.");
                rawMetricsForBuild = null;
            } else {
                rawMetricsForBuild = rawMetricsForBuild2;
            }
            if (rawMetricsForBuild == null) continue;
            RawMetricsForBuild it$iv$iv = rawMetricsForBuild;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$reduceOrNull = false;
        Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void rawMetricsForBuild2;
                RawMetricsForBuild $i$f$mapNotNullTo2 = (RawMetricsForBuild)iterator$iv.next();
                RawMetricsForBuild rawMetricsForBuild1 = (RawMetricsForBuild)accumulator$iv;
                boolean bl = false;
                accumulator$iv = INSTANCE.add(rawMetricsForBuild1, (RawMetricsForBuild)rawMetricsForBuild2);
            }
            v1 = accumulator$iv;
        }
        RawMetricsForBuild rawMetricsForBuild = v1;
        return rawMetricsForBuild != null && (set = this.aggregateMetrics(rawMetricsForBuild)) != null ? set : SetsKt.emptySet();
    }

    private final RawMetricsForBuild readFile(Path path2) {
        Ref.ObjectRef buildId = new Ref.ObjectRef();
        buildId.element = StringsKt.substringBefore$default((String)PathsKt.getName((Path)path2), (String)FILE_NAME_BUILD_ID_PREFIX_SEPARATOR, null, (int)2, null);
        HashMap rawMetrics = new HashMap();
        File file = path2.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        FilesKt.forEachLine$default((File)file, null, arg_0 -> KotlinBuildToolFusFlowProcessor.readFile$lambda$13(buildId, path2, rawMetrics, arg_0), (int)1, null);
        return new RawMetricsForBuild((String)buildId.element, rawMetrics);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<AggregatedFusMetric<?>> aggregateMetrics(RawMetricsForBuild $this$aggregateMetrics) {
        void $this$mapNotNullTo$iv$iv;
        Map<KotlinBuildToolFusMetric<?>, List<RawFusValue>> $this$mapNotNull$iv = $this$aggregateMetrics.getRawMetrics();
        boolean $i$f$mapNotNull = false;
        Map<KotlinBuildToolFusMetric<?>, List<RawFusValue>> map2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            AggregatedFusMetric it$iv$iv;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Map.Entry it = element$iv$iv;
            boolean bl2 = false;
            if (((KotlinBuildToolFusMetric)it.getKey()).process((List)it.getValue()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final RawMetricsForBuild add(RawMetricsForBuild $this$add, RawMetricsForBuild rawMetricsForBuild) {
        if (!Intrinsics.areEqual((Object)rawMetricsForBuild.getBuildId(), (Object)$this$add.getBuildId())) {
            Logger.getInstance(KotlinBuildToolFusFlowProcessor.class).warn("Try to aggregate metrics for different builds: " + $this$add.getBuildId() + " and " + rawMetricsForBuild.getBuildId());
            return $this$add;
        }
        Map<KotlinBuildToolFusMetric<?>, List<RawFusValue>> $this$forEach$iv = rawMetricsForBuild.getRawMetrics();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<KotlinBuildToolFusMetric<?>, List<RawFusValue>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object;
            void $this$getOrPut$iv;
            Map.Entry<KotlinBuildToolFusMetric<?>, List<RawFusValue>> element$iv;
            Map.Entry<KotlinBuildToolFusMetric<?>, List<RawFusValue>> entry = element$iv = iterator2.next();
            boolean bl = false;
            KotlinBuildToolFusMetric<?> metric = entry.getKey();
            List<RawFusValue> rawValues = entry.getValue();
            Map<KotlinBuildToolFusMetric<?>, List<RawFusValue>> map2 = $this$add.getRawMetrics();
            KotlinBuildToolFusMetric<?> key$iv = metric;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).addAll((Collection)rawValues);
        }
        return $this$add;
    }

    private static final Unit process$lambda$1(String buildId, List paths) {
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        Intrinsics.checkNotNullParameter((Object)paths, (String)"paths");
        INSTANCE.processFilesForBuildId(buildId, paths);
        Iterable $this$forEach$iv = paths;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path it = (Path)element$iv;
            boolean bl = false;
            Files.deleteIfExists(it);
        }
        return Unit.INSTANCE;
    }

    private static final void process$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit readFile$lambda$13(Ref.ObjectRef $buildId, Path $path, HashMap $rawMetrics, String lines) {
        block7: {
            void $this$filterTo$iv$iv;
            block6: {
                void it;
                String string;
                Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
                if (StringsKt.startsWith$default((String)lines, (String)"BUILD FINISHED", (boolean)false, (int)2, null)) {
                    return Unit.INSTANCE;
                }
                if (!StringsKt.startsWith$default((String)lines, (String)"Build:", (boolean)false, (int)2, null)) break block6;
                String string2 = string = ((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)lines, (String)"Build:", null, (int)2, null))).toString();
                Ref.ObjectRef objectRef = $buildId;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)$buildId.element, (Object)it)) {
                    Logger.getInstance(KotlinBuildToolFusFlowProcessor.class).warn("Kotlin build FUS file with name " + PathsKt.getName((Path)$path) + " contains data for build " + (String)it);
                }
                objectRef.element = string;
                break block7;
            }
            String[] it = new String[]{"="};
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)lines, (String[])it, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it2 = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !StringsKt.isBlank((CharSequence)it2);
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List metric = (List)destination$iv$iv;
            if (metric.size() != 2) break block7;
            Object object = KotlinBuildToolsMetricsKt.getKotlinFusMetricsMap().get(metric.get(0));
            if (object != null && (object = object.getMetric()) != null) {
                Object object2;
                void $this$getOrPut$iv;
                Object metricKey = object;
                boolean bl = false;
                Map map2 = $rawMetrics;
                Object key$iv = metricKey;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl3 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                ((List)object2).add(RawFusValue.box-impl(RawFusValue.constructor-impl((String)metric.get(1))));
            }
        }
        return Unit.INSTANCE;
    }

    static {
        Object[] objectArray = new String[]{"plugin-profile", STATISTICS_FOLDER_NAME};
        fusFileExtensionsGlob = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)",", (CharSequence)"*.{", (CharSequence)"}", (int)0, null, null, (int)56, null);
    }
}

