/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.scripting.k1.roots;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.scripting.k1.GradleScriptDefinitionsContributor;
import org.jetbrains.kotlin.gradle.scripting.shared.GradleScriptDefinitionsUtilsKt;
import org.jetbrains.kotlin.gradle.scripting.shared.importing.KotlinDslScriptModel;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.GradleBuildRoot;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.GradleBuildRootIndex;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.GradleBuildRootsLocator;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.GradleScriptInfo;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.Imported;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.Legacy;
import org.jetbrains.kotlin.idea.core.script.k1.configuration.ScriptingSupport;
import org.jetbrains.kotlin.idea.core.script.k1.ucache.ScriptClassRootsBuilder;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.resolve.VirtualFileScriptSource;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\u0012\u0010\u0012\u001a\u00020\u0013*\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015J \u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u001dH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/gradle/scripting/k1/roots/GradleScriptingSupport;", "Lorg/jetbrains/kotlin/idea/core/script/k1/configuration/ScriptingSupport;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "manager", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootsLocator;", "getManager", "()Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootsLocator;", "isApplicable", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isConfigurationLoadingInProgress", "Lorg/jetbrains/kotlin/psi/KtFile;", "collectConfigurations", "", "builder", "Lorg/jetbrains/kotlin/idea/core/script/k1/ucache/ScriptClassRootsBuilder;", "afterUpdate", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/Imported;", "selectScriptDefinition", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "script", "Lorg/jetbrains/kotlin/gradle/scripting/shared/importing/KotlinDslScriptModel;", "definitions", "", "Companion", "kotlin.gradle.scripting.k1"})
@SourceDebugExtension(value={"SMAP\nGradleBuildRootsLocatorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleBuildRootsLocatorImpl.kt\norg/jetbrains/kotlin/gradle/scripting/k1/roots/GradleScriptingSupport\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,297:1\n1869#2,2:298\n1869#2,2:300\n1869#2,2:303\n295#2,2:305\n1#3:302\n*S KotlinDebug\n*F\n+ 1 GradleBuildRootsLocatorImpl.kt\norg/jetbrains/kotlin/gradle/scripting/k1/roots/GradleScriptingSupport\n*L\n240#1:298,2\n250#1:300,2\n270#1:303,2\n288#1:305,2\n*E\n"})
public final class GradleScriptingSupport
implements ScriptingSupport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public GradleScriptingSupport(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final GradleBuildRootsLocator getManager() {
        return GradleBuildRootsLocator.Companion.getInstance(this.project);
    }

    @Override
    public boolean isApplicable(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        GradleBuildRootsLocator $this$isApplicable_u24lambda_u240 = this.getManager();
        boolean bl = false;
        GradleBuildRootsLocator.ScriptUnderRoot scriptUnderRoot = $this$isApplicable_u24lambda_u240.findScriptBuildRoot(file);
        if (scriptUnderRoot == null) {
            return false;
        }
        GradleBuildRootsLocator.ScriptUnderRoot scriptUnderRoot2 = scriptUnderRoot;
        if (scriptUnderRoot2.getNearest() instanceof Legacy) {
            return false;
        }
        GradleBuildRootIndex gradleBuildRootIndex = $this$isApplicable_u24lambda_u240.getRoots();
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return !gradleBuildRootIndex.isStandaloneScript(string);
    }

    @Override
    public boolean isConfigurationLoadingInProgress(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        GradleBuildRootsLocator $this$isConfigurationLoadingInProgress_u24lambda_u241 = this.getManager();
        boolean bl = false;
        VirtualFile virtualFile = file.getOriginalFile().getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        Object object = $this$isConfigurationLoadingInProgress_u24lambda_u241.findScriptBuildRoot(virtualFile);
        if (object == null || (object = ((GradleBuildRootsLocator.ScriptUnderRoot)object).getNearest()) == null) {
            return false;
        }
        return ((GradleBuildRoot)object).isImportingInProgress();
    }

    @Override
    public void collectConfigurations(@NotNull ScriptClassRootsBuilder builder2) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        GradleBuildRootsLocator $this$collectConfigurations_u24lambda_u243 = this.getManager();
        boolean bl = false;
        Iterable $this$forEach$iv = $this$collectConfigurations_u24lambda_u243.getRoots().getList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GradleBuildRoot root = (GradleBuildRoot)element$iv;
            boolean bl2 = false;
            if (!(root instanceof Imported)) continue;
            this.collectConfigurations((Imported)root, builder2);
        }
    }

    @Override
    public void afterUpdate() {
        GradleBuildRootsLocator $this$afterUpdate_u24lambda_u246 = this.getManager();
        boolean bl = false;
        Iterable $this$forEach$iv = $this$afterUpdate_u24lambda_u246.getRoots().getList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GradleBuildRoot root = (GradleBuildRoot)element$iv;
            boolean bl2 = false;
            if (!root.getImporting().compareAndSet(GradleBuildRoot.ImportingStatus.updatingCaches, GradleBuildRoot.ImportingStatus.updated)) continue;
            GradleBuildRootsLocator.updateNotifications$default($this$afterUpdate_u24lambda_u246, false, arg_0 -> GradleScriptingSupport.afterUpdate$lambda$6$lambda$5$lambda$4(root, arg_0), 1, null);
        }
    }

    public final void collectConfigurations(@NotNull Imported $this$collectConfigurations, @NotNull ScriptClassRootsBuilder builder2) {
        Intrinsics.checkNotNullParameter((Object)$this$collectConfigurations, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Path path2 = $this$collectConfigurations.getJavaHome();
        if (path2 != null) {
            Path it = path2;
            boolean bl = false;
            builder2.getSdks().addSdk(it);
        }
        List<ScriptDefinition> definitions2 = GradleScriptDefinitionsContributor.Companion.getDefinitions(builder2.getProject(), $this$collectConfigurations.getPathPrefix(), $this$collectConfigurations.getData().getGradleHome(), $this$collectConfigurations.getData().getJavaHome());
        if (definitions2 == null) {
            builder2.useCustomScriptDefinition();
        }
        builder2.addTemplateClassesRoots((Collection<String>)GradleScriptDefinitionsUtilsKt.getDefinitionsTemplateClasspath($this$collectConfigurations.getData().getGradleHome()));
        Iterable $this$forEach$iv = $this$collectConfigurations.getData().getModels();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScriptDefinition scriptDefinition;
            KotlinDslScriptModel script = (KotlinDslScriptModel)element$iv;
            boolean bl = false;
            if (definitions2 != null) {
                List<ScriptDefinition> it;
                boolean bl2 = false;
                scriptDefinition = this.selectScriptDefinition(script, it);
            } else {
                scriptDefinition = null;
            }
            ScriptDefinition definition = scriptDefinition;
            builder2.addCustom(script.getFile(), (Collection<String>)script.getClassPath(), (Collection<String>)script.getSourcePath(), new GradleScriptInfo($this$collectConfigurations, definition, script, builder2.getProject()));
        }
    }

    private final ScriptDefinition selectScriptDefinition(KotlinDslScriptModel script, List<? extends ScriptDefinition> definitions2) {
        Object v1;
        block2: {
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(script.getFile());
            if (virtualFile == null) {
                return null;
            }
            VirtualFile file = virtualFile;
            VirtualFileScriptSource scriptSource = new VirtualFileScriptSource(file, null, 2, null);
            Iterable $this$firstOrNull$iv = definitions2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ScriptDefinition it = (ScriptDefinition)((Object)element$iv);
                boolean bl = false;
                if (!it.isScript(scriptSource)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        return v1;
    }

    private static final boolean afterUpdate$lambda$6$lambda$5$lambda$4(GradleBuildRoot $root, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.startsWith$default((String)it, (String)$root.getPathPrefix(), (boolean)false, (int)2, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/gradle/scripting/k1/roots/GradleScriptingSupport$Companion;", "", "<init>", "()V", "isApplicable", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.gradle.scripting.k1"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isApplicable(@NotNull VirtualFile file, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            GradleScriptingSupport gradleScriptingSupport = (GradleScriptingSupport)ScriptingSupport.Companion.getEP_NAME().findExtension(GradleScriptingSupport.class, (AreaInstance)project);
            if (gradleScriptingSupport == null) {
                return false;
            }
            GradleScriptingSupport support = gradleScriptingSupport;
            return support.isApplicable(file);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

