/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.processors;

import org.gradle.api.internal.tasks.testing.TestDefinition;
import org.gradle.api.internal.tasks.testing.TestDefinitionProcessor;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.internal.Factory;

public class RestartEveryNTestDefinitionProcessor<D extends TestDefinition>
implements TestDefinitionProcessor<D> {
    private final Factory<TestDefinitionProcessor<D>> factory;
    private final long restartEvery;
    private long testCount;
    private TestResultProcessor resultProcessor;
    private volatile boolean stoppedNow;
    private volatile TestDefinitionProcessor<D> processor;

    public RestartEveryNTestDefinitionProcessor(Factory<TestDefinitionProcessor<D>> factory, long restartEvery) {
        this.factory = factory;
        this.restartEvery = restartEvery;
    }

    public void startProcessing(TestResultProcessor resultProcessor) {
        this.resultProcessor = resultProcessor;
    }

    public void processTestDefinition(D testDefinition) {
        if (this.stoppedNow) {
            return;
        }
        if (this.processor == null) {
            this.processor = (TestDefinitionProcessor)this.factory.create();
            this.processor.startProcessing(this.resultProcessor);
        }
        this.processor.processTestDefinition(testDefinition);
        ++this.testCount;
        if (this.testCount == this.restartEvery) {
            this.endBatch();
        }
    }

    public void stop() {
        if (this.processor != null) {
            this.endBatch();
        }
    }

    public void stopNow() {
        this.stoppedNow = true;
        TestDefinitionProcessor<D> toStop = this.processor;
        if (toStop != null) {
            toStop.stopNow();
        }
    }

    private void endBatch() {
        try {
            this.processor.stop();
        }
        finally {
            this.processor = null;
            this.testCount = 0L;
        }
    }
}

