/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.io.vavr.control;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.kotlin.io.vavr.Value;
import org.jetbrains.kotlin.io.vavr.collection.Iterator;

public interface Validation<E, T>
extends Value<T>,
Serializable {
    public static final long serialVersionUID = 1L;

    public boolean isValid();

    public boolean isInvalid();

    @Override
    default public boolean isEmpty() {
        return this.isInvalid();
    }

    @Override
    public T get();

    @Override
    public String toString();

    @Override
    default public void forEach(Consumer<? super T> action) {
        Objects.requireNonNull(action, "action is null");
        if (this.isValid()) {
            action.accept(this.get());
        }
    }

    @Override
    default public boolean isAsync() {
        return false;
    }

    @Override
    default public boolean isLazy() {
        return false;
    }

    @Override
    default public boolean isSingleValued() {
        return true;
    }

    @Override
    default public Iterator<T> iterator() {
        return this.isValid() ? Iterator.of(this.get()) : Iterator.empty();
    }
}

